<?php
/**
 * @return string
 */
function osf_theme_custom_css() {
    $a1root = include trailingslashit(WORLDLIFE_CORE_PLUGIN_DIR) . 'inc/customize/a1root.php';
    $grid = include trailingslashit(WORLDLIFE_CORE_PLUGIN_DIR) . 'inc/customize/grid.php';
    $button = include trailingslashit(WORLDLIFE_CORE_PLUGIN_DIR) . 'inc/customize/button.php';
    $error_404 = include trailingslashit(WORLDLIFE_CORE_PLUGIN_DIR) . 'inc/customize/error-404.php';
    $heading = include trailingslashit(WORLDLIFE_CORE_PLUGIN_DIR) . 'inc/customize/heading.php';
    $main_layout = include trailingslashit(WORLDLIFE_CORE_PLUGIN_DIR) . 'inc/customize/main-layout.php';
    $page_bg = include trailingslashit(WORLDLIFE_CORE_PLUGIN_DIR) . 'inc/customize/page-bg.php';
    $page_title = include trailingslashit(WORLDLIFE_CORE_PLUGIN_DIR) . 'inc/customize/page-title.php';
    $css = <<<CSS
{$a1root}
{$grid}
{$error_404}
{$heading}
{$main_layout}
{$page_bg}
{$page_title}
{$button}
CSS;

    $css = apply_filters('osf_theme_customizer_css', $css);
    $css = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $css);
    $css = str_replace(': ', ':', $css);
    $css = str_replace(array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css);

    return $css;
}

/**
 * @return string
 */
function osf_theme_custom_css_no_cache($css) {
    global $osf_header;
    if ($osf_header) {
        $bg_header = osf_get_metabox($osf_header->ID, 'osf_header_bg_color_mobile', '');
        if(!empty($bg_header)){
            $css .= '@media(max-width: 991px){.opal-header-absolute .site-header{background:'.$bg_header.';}}';
        }
    }

    // Footer Css
    if (is_page() && osf_get_metabox(get_the_ID(), 'osf_enable_custom_footer', false)) {
        $footer_padding_top = osf_get_metabox(get_the_ID(), 'osf_footer_padding_top', 15);
        $css .= '.site-footer {padding-top:' . $footer_padding_top . 'px!important;}';
    }

    if (is_page()) {
        $page_title_bar = $page_title_css_color = $breadcrumb_css = '';
        $page_title_bg_color = get_post_meta(get_the_ID(), 'osf_breadcrumb_bg_color', 1);
        $page_title_bg_image = get_post_meta(get_the_ID(), 'osf_breadcrumb_bg_image', 1);
        $breadcrumb_color = get_post_meta(get_the_ID(), 'osf_breadcrumb_text_color', 1);
        $page_title_color = get_post_meta(get_the_ID(), 'osf_heading_color', 1);
        if (!empty($page_title_bg_color) && $page_title_bg_color != '#fafafa') {
            $css .= '.page-title-bar {background-color: ' . $page_title_bg_color . ';}';
        }
        if (!empty($page_title_bg_image)) {
            $page_title_bar .= "background-image: url({$page_title_bg_image});";
            $css .= '.page-title-bar {' . $page_title_bar . '}';
        }
        if ($page_title_color && $page_title_color != '#666') {
            $page_title_css_color .= "color: {$page_title_color};";
            $css .= '.page-title{' . $page_title_css_color . '}';
        }
        if (!empty($breadcrumb_color)) {
            $breadcrumb_color = ariColor::new_color($breadcrumb_color);
            $breadcrumb_css .= "color: {$breadcrumb_color->toCSS()};";
            $css .= '.breadcrumb, .breadcrumb span, .breadcrumb * {' . $breadcrumb_css . '}';
        }

    }
    return $css;
}

add_filter('osf_theme_custom_inline_css', 'osf_theme_custom_css_no_cache');