<?php
add_action('elementor/controls/controls_registered', 'osf_elementor_opal_icon_control_custom');

/**
 * @var \Elementor\Controls_Manager $manager
 */
function osf_elementor_opal_icon_control_custom($manager) {
    class Opal_Icon_Control extends \Elementor\Control_Icon {
        protected function get_default_settings() {
            $icons = json_decode(file_get_contents(trailingslashit(WORLDLIFE_CORE_PLUGIN_DIR) . 'inc/vendors/elementor/icons.json'), true);
            $options = wp_parse_args($icons, self::get_icons());
            return [
                'options' => $options,
                'include' => '',
                'exclude' => '',
            ];
        }
    }

    $manager->unregister_control('icon');
    $manager->register_control('icon', new Opal_Icon_Control());
}
