<?php
if (!defined('ABSPATH')) {
    exit;
}

//if (has_post_thumbnail()) {
if ('' !== get_the_post_thumbnail()) {
    $thumbnail_url = get_the_post_thumbnail_url(get_the_ID(), 'worldlife-featured-image-full');
} else {
    $thumbnail_url = worldlife_get_placeholder_image();
}
?>
<article <?php post_class('osf-event-article osf-event-style-2 col-md-6 col-lg-8 '); ?>>
    <div class="event-inner" style="background-image: url(<?php echo esc_url($thumbnail_url) ?>)">
        <div class="event-content">
            <div class="event-wap">
                <div class="entry-meta">
                    <div class="event-info">
                        <?php if (!empty(osf_get_metabox(get_the_ID(), 'osf_event_date'))): ?>
                            <?php echo sprintf('<time datetime="%1$s">%2$s</time>',
                                date(DATE_W3C, osf_get_metabox(get_the_ID(), 'osf_event_date')),
                                date('Y M d@ h:ia', osf_get_metabox(get_the_ID(), 'osf_event_date'))
                            );
                            ?>
                        <?php endif; ?>
                        <?php if (!empty(osf_get_metabox(get_the_ID(), 'osf_event_date_end')) && !empty(osf_get_metabox(get_the_ID(), 'osf_event_date'))): ?>
                            <?php echo sprintf('<time datetime="%1$s">- %2$s</time>',
                                date(DATE_W3C, osf_get_metabox(get_the_ID(), 'osf_event_date_end')),
                                date('Y M d@ h:ia', osf_get_metabox(get_the_ID(), 'osf_event_date_end'))
                            );
                            ?>
                        <?php endif; ?>
                    </div>
                </div>
                <header class="entry-header">
                    <?php the_title('<h3 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h3>'); ?>
                </header><!-- .entry-header -->

<!--                --><?php //if (!empty(get_the_content())): ?>
<!--                    <div class="entry-content">-->
<!--                        --><?php //echo wp_trim_words(get_the_content(), 20); ?>
<!--                    </div>-->
<!--                --><?php //endif; ?>
            </div>
            <?php if (!empty(osf_get_metabox(get_the_ID(), 'osf_event_venue_add'))): ?>
                <div class="event-add">
                    <div class="event-wap">
                        <span class="label"><?php echo esc_html__('Location:', 'worldlife') ?> </span>
                        <span class="value"> <?php echo osf_get_metabox(get_the_ID(), 'osf_event_venue_add'); ?></span>
                    </div>
                </div>
            <?php endif; ?>


        </div>
    </div>
</article>
<!-- #post-## -->

