<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="post-inner">

	    <?php if ('' !== get_the_post_thumbnail() && !get_post_gallery()) : ?>
            <div class="post-thumbnail">
                <a href="<?php the_permalink(); ?>">
				    <?php the_post_thumbnail('worldlife-featured-image-full'); ?>
                </a>
            </div><!-- .post-thumbnail -->
	    <?php endif; ?>

        <header class="entry-header">
            <?php if ('post' === get_post_type()) : ?>
                <div class="entry-meta">
                    <?php worldlife_posted_on(); ?>
                </div><!-- .entry-meta -->
            <?php endif; ?>

            <?php

            if (is_single()) {
            } elseif (is_front_page() && is_home()) {
                the_title('<h3 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h3>');
            } else {
                the_title('<h2 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>');
            }
            ?>

            <?php if (is_single()) : ?>
                <div class="entry-avatar">
                    <?php echo get_avatar(get_the_author_meta('email'), 38) ?>
                    <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))) ?>"><?php the_author() ?></a>
                </div><!-- .entry-meta -->
            <?php endif; ?>

        </header><!-- .entry-header -->

        <?php
        // If not a single post, highlight the gallery.
        if (get_post_gallery()) {
            echo '<div class="entry-gallery">';
            echo get_post_gallery();
            echo '</div>';
        };
        ?>


        <div class="entry-content">

            <?php
            if (is_single() || !get_post_gallery()) {

                /* translators: %s: Name of current post */
                the_content(
                    sprintf(
                        esc_html__('Read more', 'worldlife') . '<span class="screen-reader-text"> "%s"</span>',
                        get_the_title()
                    )
                );

                wp_link_pages(array(
                    'before'      => '<div class="page-links">' . esc_html__('Pages:', 'worldlife'),
                    'after'       => '</div>',
                    'link_before' => '<span class="page-number">',
                    'link_after'  => '</span>',
                ));

            };
            ?>

        </div><!-- .entry-content -->

        <?php
        if (is_single()) {
            worldlife_entry_footer();
            worldlife_social_share();
        }
        ?>
    </div>
</article><!-- #post-## -->
