<?php
if (!defined('ABSPATH')) {
    exit;
}

if (has_post_thumbnail()) {
    $thumbnail_url = get_the_post_thumbnail_url(get_the_ID(), 'worldlife-featured-image-small');
} else {
    $thumbnail_url = worldlife_get_placeholder_image();
}
?>
<article <?php post_class('osf-stories-article'); ?>>
    <div class="post-inner row">
        <div class="post-thumbnail col-md-6 col-sm-12">
            <img src="<?php echo esc_attr($thumbnail_url); ?>" class="img-responsive" alt="<?php the_title_attribute(); ?>"
                 title="<?php the_title_attribute(); ?>">
        </div><!-- .post-thumbnail -->
        <div class="entry-content col-md-6 col-sm-12">
            <?php the_title('<h3 class="stories-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h3>'); ?>
            <?php the_date('', '<time class="entry-date">', '</time>') ?>

            <p class="description"><?php echo worldlife_get_excerpt(23); ?></p>
        </div>
    </div>
</article><!-- #post-## -->

